
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_PatientTransfusionReaction : BaseTest 
	{
		private DataRow _drPtr;
		private DataRow _setUpData;
		private DataRow _existingData;

		private DataTable _dtPtr;
		private DataTable _dtPatient;

		private BOL.PatientTransfusionReaction _tstPTR;
		private BOL.PatientTransfusionReaction _testNullPatientTransfusionReaction;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//Get patient information for any data that we need to create
				this._dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 PatientGuid FROM Patient WHERE RecordStatusCode = 'A'", true);

				// string strSQL = "SELECT TOP 1 * FROM PatientTransfusionReaction";
				string strSQL = "SELECT TOP 1 * FROM Patient P ";
				strSQL = string.Concat(strSQL, "JOIN PatientTransfusionReaction PTR ON PTR.PatientGuid = P.PatientGuid ");
				strSQL = string.Concat(strSQL, "LEFT OUTER JOIN PatientTransfusion PT ON PT.PatientGuid = P.PatientGuid ");
				strSQL = string.Concat(strSQL, "JOIN TransfusionReaction TR ON TR.PatientTransfusionGuid = PT.PatientTransfusionGuid ");
				strSQL = string.Concat(strSQL, "AND TR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid ");
				strSQL = string.Concat(strSQL, "JOIN TransfusionReactionType TRT ON TRT.TransfusionReactionTypeCode = PTR.TransfusionReactionTypeCode ");
				strSQL = string.Concat(strSQL, "WHERE PTR.RecordStatusCode NOT IN ('E','X') ORDER BY PTR.LastUpdateDate DESC");

				this._dtPtr = UnitTestUtil.RunSQLGetDataTable(strSQL, false);

				if (_dtPtr.Rows.Count <= 0)
				{
					this.CreateTestData();
				}
				
				this._dtPtr = UnitTestUtil.RunSQLGetDataTable(strSQL, true);
				this._drPtr = this._dtPtr.Rows[0];

				this._tstPTR = new BOL.PatientTransfusionReaction(this._drPtr);
				this._testNullPatientTransfusionReaction = new BOL.PatientTransfusionReaction(this._dtPtr.NewRow());

				this._setUpData = GetDataForPersistingNewPtr();
			
				this.RefreshData = false;
			}

			this._setUpData = GetDataForPersistingNewPtr();

			
			string strsql2 = "SELECT TOP 1 PTR.PatientTransfusionReactionGuid, PTR.PatientGuid,  ";
			strsql2 += " PTR.OrderedTestGuid, PTR.RowVersion, OT.PatientSpecimenGuid,  ";
			strsql2 += " PTR.PreSpecimenGuid, PT.BloodUnitGuid FROM PatientTransfusionReaction PTR";
			strsql2 += " JOIN PatientTransfusion PT ON PTR.PatientGuid = PT.PatientGuid";
			strsql2 += " JOIN OrderedTest OT ON PTR.OrderedTestGuid = OT.OrderedTestGuid";
			strsql2 += " WHERE OT.PatientSpecimenGuid IS NOT NULL";
	
			this._existingData = UnitTestUtil.RunSQLGetDataRow(strsql2);
		}

		#region Properties

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.PatientTransfusionReaction tmpObject = new BOL.PatientTransfusionReaction(this._drPtr);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.DivisionCode))
				Assert.IsTrue(tmpObject.DivisionCode == this._drPtr[TABLES.PatientTransfusionReaction.DivisionCode].ToString());

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.EntryDateTime))
				Assert.IsTrue(tmpObject.EntryDateTime == (System.DateTime)this._drPtr[TABLES.PatientTransfusionReaction.EntryDateTime]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.EntryTechId))
				Assert.IsTrue(tmpObject.EntryTechId == this._drPtr[TABLES.PatientTransfusionReaction.EntryTechId].ToString());

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.InvestigatedDateTime))
				Assert.IsTrue(tmpObject.InvestigatedDateTime == (System.DateTime)this._drPtr[TABLES.PatientTransfusionReaction.InvestigatedDateTime]);

			Assert.IsTrue(tmpObject.IsDirty == true);
			Assert.IsTrue(tmpObject.IsNew == false);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.MedicalDirectorName))
				Assert.IsTrue(tmpObject.MedicalDirectorName == this._drPtr[TABLES.PatientTransfusionReaction.MedicalDirectorName].ToString());

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.NotedDateTime))
				Assert.IsTrue(tmpObject.NotedDateTime == (System.DateTime)this._drPtr[TABLES.PatientTransfusionReaction.NotedDateTime]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.OrderedTestGuid))
				Assert.IsTrue(tmpObject.OrderedTestGuid == (System.Guid)this._drPtr[TABLES.PatientTransfusionReaction.OrderedTestGuid]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.PatientGuid))
				Assert.IsTrue(tmpObject.PatientGuid == (System.Guid)this._drPtr[TABLES.PatientTransfusionReaction.PatientGuid]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid))
				Assert.IsTrue(tmpObject.PatientTransfusionReactionGuid == (System.Guid)this._drPtr[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator))
				Assert.IsTrue(tmpObject.PostSpecimenNotAvailableIndicator == (bool)this._drPtr[TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator))
				Assert.IsTrue(tmpObject.PreSpecimenNotAvailableIndicator == (bool)this._drPtr[TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode))
				Assert.IsTrue(tmpObject.TransfusionReactionTypeCode == (Common.TransfusionReactionType)this._drPtr[TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode].ToString()[0]);

			if (!this._drPtr.IsNull(TABLES.PatientTransfusionReaction.RecordStatusCode))
				Assert.IsTrue(tmpObject.RecordStatusCode ==  Common.Utility.GetRecordStatusCodeFromString(this._drPtr[TABLES.PatientTransfusionReaction.RecordStatusCode].ToString()));
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			//
			//Now we can create  a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			PatientTransfusionReaction ptrTest = new PatientTransfusionReaction(orderedTestGuid);
			Assert.IsTrue(ptrTest.IsNew == false);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_Guid_Fail()
		{
			PatientTransfusionReaction ptr = new PatientTransfusionReaction(Guid.Empty);
			Assert.IsTrue(ptr.IsNew == true);
		}

		[Test]
		public void DivisionCode_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			this._tstPTR.DivisionCode = tmpValue;
			Assert.IsTrue(this._tstPTR.DivisionCode == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.DivisionCode == string.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail()
		{
		}

		[Test]
		public void EntryDateTime_Pass()
		{
			System.DateTime tmpValue = System.DateTime.Now;

			this._tstPTR.EntryDateTime = tmpValue;
			Assert.IsTrue(this._tstPTR.EntryDateTime == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.EntryDateTime == System.DateTime.MinValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EntryDateTime_Fail()
		{
		}

		[Test]
		public void EntryTechId_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			this._tstPTR.EntryTechId = tmpValue;
			Assert.IsTrue(this._tstPTR.EntryTechId == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.EntryTechId == string.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EntryTechId_Fail()
		{
		}

		[Test]
		public void InvestigatedDateTime_Pass()
		{
			System.DateTime tmpValue = System.DateTime.Now;

			this._tstPTR.InvestigatedDateTime = tmpValue;
			Assert.IsTrue(this._tstPTR.InvestigatedDateTime == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.InvestigatedDateTime == System.DateTime.MinValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvestigatedDateTime_Fail()
		{
		}

		[Test]
		public void MedicalDirectorName_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			this._tstPTR.MedicalDirectorName = tmpValue;
			Assert.IsTrue(this._tstPTR.MedicalDirectorName == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.MedicalDirectorName == string.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MedicalDirectorName_Fail()
		{
		}

		[Test]
		public void NotedDateTime_Pass()
		{
			System.DateTime tmpValue = System.DateTime.Now;

			this._tstPTR.NotedDateTime = tmpValue;
			Assert.IsTrue(this._tstPTR.NotedDateTime == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.NotedDateTime == System.DateTime.MinValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NotedDateTime_Fail()
		{
		}

		[Test]
		public void OrderedTestGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._tstPTR.OrderedTestGuid = tmpValue;
			Assert.IsTrue(this._tstPTR.OrderedTestGuid == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.OrderedTestGuid == System.Guid.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedTestGuid_Fail()
		{
		}

		[Test]
		public void PatientGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._tstPTR.PatientGuid = tmpValue;
			Assert.IsTrue(this._tstPTR.PatientGuid == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.PatientGuid == System.Guid.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientGuid_Fail()
		{
		}

		[Test]
		public void PatientTransfusionReactionGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._tstPTR.PatientTransfusionReactionGuid = tmpValue;
			Assert.IsTrue(this._tstPTR.PatientTransfusionReactionGuid == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.PatientTransfusionReactionGuid == System.Guid.Empty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionReactionGuid_Fail()
		{
		}

		[Test]
		public void PostSpecimenNotAvailableIndicator_Pass()
		{
			bool tmpValue = !this._tstPTR.PostSpecimenNotAvailableIndicator;

			this._tstPTR.PostSpecimenNotAvailableIndicator = tmpValue;
			Assert.IsTrue(this._tstPTR.PostSpecimenNotAvailableIndicator == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.PostSpecimenNotAvailableIndicator == false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PostSpecimenNotAvailableIndicator_Fail()
		{
		}

		[Test]
		public void PreSpecimenNotAvailableIndicator_Pass()
		{
			bool tmpValue = !this._tstPTR.PreSpecimenNotAvailableIndicator;

			this._tstPTR.PreSpecimenNotAvailableIndicator = tmpValue;
			Assert.IsTrue(this._tstPTR.PreSpecimenNotAvailableIndicator == tmpValue);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.PreSpecimenNotAvailableIndicator == false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PreSpecimenNotAvailableIndicator_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			Common.RecordStatusCode code = Common.RecordStatusCode.Active;

			this._tstPTR.RecordStatusCode = code;
			Assert.IsTrue(this._tstPTR.RecordStatusCode == code);

			Assert.IsTrue(this._testNullPatientTransfusionReaction.RecordStatusCode == Common.RecordStatusCode.Unknown);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void TransfusionReactionTypeCode_Pass()
		{
			Common.TransfusionReactionType tmpValue = Common.TransfusionReactionType.AcuteHemolytic;

			this._tstPTR.TransfusionReactionTypeCode = tmpValue;
			Assert.IsTrue(this._tstPTR.TransfusionReactionTypeCode == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionReactionTypeCode_Fail()
		{
		}

		[Test]
		public void TransfusionReactionTypeText_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			this._tstPTR.TransfusionReactionTypeText = tmpValue;
			Assert.IsTrue(this._tstPTR.TransfusionReactionTypeText == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionReactionTypeText_Fail()
		{
		}

		#endregion

		[Test]
		public void GetTransfusionReactionsForPatient_Pass()
		{
			string test = this._tstPTR.PatientGuid.ToString();

			System.Collections.ArrayList tmpArray = BOL.PatientTransfusionReaction.GetTransfusionReactionsForPatient(this._tstPTR.PatientGuid);

			Assert.IsTrue(tmpArray.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionReactionsForPatient_Fail()
		{
		}

		[Test]
		public void GetTransfusionReactionsForPatientCount_Pass()
		{
			Assert.IsTrue(BOL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount(this._tstPTR.PatientGuid) >= 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetTransfusionReactionsForPatientCount_Fail()
		{
			Assert.IsTrue(BOL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount(Guid.Empty) == 0);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drNew = this._dtPtr.NewRow();

			drNew = this._tstPTR.LoadDataRowFromThis(drNew);

			Assert.IsTrue(drNew[TABLES.PatientTransfusionReaction.DivisionCode].ToString() == this._tstPTR.DivisionCode);
			Assert.IsTrue((System.DateTime)drNew[TABLES.PatientTransfusionReaction.EntryDateTime] == this._tstPTR.EntryDateTime);
			Assert.IsTrue(drNew[TABLES.PatientTransfusionReaction.EntryTechId].ToString() == this._tstPTR.EntryTechId);
			Assert.IsTrue((System.DateTime)drNew[TABLES.PatientTransfusionReaction.InvestigatedDateTime] == this._tstPTR.InvestigatedDateTime);
			Assert.IsTrue(drNew[TABLES.PatientTransfusionReaction.MedicalDirectorName].ToString() == this._tstPTR.MedicalDirectorName);
			Assert.IsTrue((System.DateTime)drNew[TABLES.PatientTransfusionReaction.NotedDateTime] == this._tstPTR.NotedDateTime);
			Assert.IsTrue((System.Guid)drNew[TABLES.PatientTransfusionReaction.OrderedTestGuid] == this._tstPTR.OrderedTestGuid);
			Assert.IsTrue((System.Guid)drNew[TABLES.PatientTransfusionReaction.PatientGuid] == this._tstPTR.PatientGuid);
			Assert.IsTrue((System.Guid)drNew[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] == this._tstPTR.PatientTransfusionReactionGuid);
			Assert.IsTrue((bool)drNew[TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] == this._tstPTR.PostSpecimenNotAvailableIndicator);
			Assert.IsTrue((bool)drNew[TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] == this._tstPTR.PreSpecimenNotAvailableIndicator);
			Assert.IsTrue(drNew[TABLES.PatientTransfusionReaction.RecordStatusCode].ToString() == this._tstPTR.RecordStatusCode.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		// *************************************************************************************************************************

		[Test]
		public void SaveSpecimenChecks_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			//
			//Now we can create  a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = false;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = false;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);

			// Comments
			ArrayList comments = new ArrayList();
			//
			PatientTransfusionComment postSpecimenComment = new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.PostTransfusionSpecimenChecks);
			postSpecimenComment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			postSpecimenComment.PatientTransfusionCommentText = "Post Specimen Comment Test";
			postSpecimenComment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenComment.LastUpdateUser = Common.LogonUser.LogonUserName;
			postSpecimenComment.RecordStatusCode = "A";
			comments.Add(postSpecimenComment);
			//
			PatientTransfusionComment preSpecimenComment = new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.PreTransfusionSpecimenChecks);
			preSpecimenComment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			preSpecimenComment.PatientTransfusionCommentText = "Pre Specimen Comment Test";
			preSpecimenComment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenComment.LastUpdateUser = Common.LogonUser.LogonUserName;
			preSpecimenComment.RecordStatusCode = "A";
			comments.Add(preSpecimenComment);
			//
			bool success = ptr.SaveSpecimenCheckData(orderedTest, comments, null);
			Assert.IsTrue(success, "Error saving specimen checks:");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void SaveSpecimenChecks_Fail()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			//
			//Now we can create  a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			// This should cause a rowversion exception.
			orderedTest.RowVersion=new byte[8];
			//
			bool success = ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			Assert.IsTrue(!success);
		}

		[Test]
		public void SaveImplicatedBloodUnits_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = false;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			// Comments
			ArrayList comments = new ArrayList();
			PatientTransfusionComment implicatedUnitComment = new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.ImplicatedUnits);
			implicatedUnitComment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			implicatedUnitComment.PatientTransfusionGuid = patientTransfusionGuid;
			implicatedUnitComment.PatientTransfusionCommentText = "Implicated Unit Comment Test";
			implicatedUnitComment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			implicatedUnitComment.LastUpdateUser = Common.LogonUser.LogonUserName;
			implicatedUnitComment.RecordStatusCode = "A";
			comments.Add(implicatedUnitComment);
			//
			bool success = ptr.SaveImplicatedBloodUnits(transfusionReactions, comments, null);
			Assert.IsTrue(success);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void SaveImplicatedBloodUnits_Fail()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = false;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			// Comments
			ArrayList comments = new ArrayList();
			PatientTransfusionComment implicatedUnitComment = new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.ImplicatedUnits);
			implicatedUnitComment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			implicatedUnitComment.PatientTransfusionGuid = patientTransfusionGuid;
			implicatedUnitComment.PatientTransfusionCommentText = "Implicated Unit Comment Test";
			implicatedUnitComment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			implicatedUnitComment.LastUpdateUser = Common.LogonUser.LogonUserName;
			implicatedUnitComment.RecordStatusCode = "A";
			comments.Add(implicatedUnitComment);
			//
			//This should cause a row version exception
			ptr.RowVersion = new byte[8];
			bool success = ptr.SaveImplicatedBloodUnits(transfusionReactions, comments, null);
			Assert.IsTrue(!success);
		}

		[Test]
		public void GetImplicatedBloodUnits_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);

			ArrayList units = ptr.GetImplicatedBloodUnits(patientGuid);
			Assert.IsTrue(units.Count > 0);
		}

		[Test]
		public void GetImplicatedBloodUnits_Fail()
		{
			PatientTransfusionReaction ptr = new PatientTransfusionReaction(Guid.NewGuid());
			ArrayList units = ptr.GetImplicatedBloodUnits(Guid.NewGuid());
			Assert.IsTrue(units.Count == 0);
		}

		[Test]
		public void GetImplicatedTransfusionRecords_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);

			ArrayList transRecords = ptr.GetImplicatedTransfusionRecords(patientGuid);
			Assert.IsTrue(transRecords.Count > 0);
		}

		[Test]
		public void GetImplicatedTransfusionRecords_Fail()
		{
			PatientTransfusionReaction ptr = new PatientTransfusionReaction(Guid.NewGuid());
			ArrayList transRecords = ptr.GetImplicatedTransfusionRecords(Guid.NewGuid());
			Assert.IsTrue(transRecords.Count == 0);
		}

		[Test]
		public void SaveSymptons_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(2);
			symptoms.Add(allSymptoms[2]);
			symptoms.Add(allSymptoms[3]);
			//
			PatientTransfusionComment comment = new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.SymptomDetails);
			comment.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			comment.PatientTransfusionCommentText = "The patient is also experiencing severe headaches.";
			comment.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			comment.LastUpdateUser = Common.LogonUser.LogonUserName;
			comment.RecordStatusCode = "A";
			//
			bool success = ptr.SaveSymptoms(symptoms, comment);
			Assert.IsTrue(success);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void SaveSymptons_Fail()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(2);
			symptoms.Add(allSymptoms[2]);
			symptoms.Add(allSymptoms[3]);
			//
			//This should cause a row version exception
			ptr.RowVersion = new byte[8];
			bool success = ptr.SaveSymptoms(symptoms, null);
			Assert.IsTrue(!success);
		}

		[Test]
		public void GetSymtoms_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(2);
			symptoms.Add(allSymptoms[0]);
			symptoms.Add(allSymptoms[1]);
			//
			ptr.SaveSymptoms(symptoms, null);
			//
			ArrayList getSymptoms = ptr.GetSymtoms();
			Assert.AreEqual(2, getSymptoms.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSymtoms_Fail()
		{
		}

		[Test]
		public void SaveSerologicTests_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];
			Rack rack = new BOL.Rack(rackGuid);
			//
			TestingMethod testingMethod = new TestingMethod("T");
			//
			// Blood Unit ABO + Rh Interp
			BloodUnitTest bloodUnitAboTest = new BloodUnitTest(bloodUnitGuid, 105);
			bloodUnitAboTest.TestDate = System.DateTime.Now;
			bloodUnitAboTest.TestResultId = "A";
			bloodUnitAboTest.EntryMethodCode = "M";
			bloodUnitAboTest.TestingMethod = testingMethod;
			bloodUnitAboTest.OrderableTestId = 10;
			bloodUnitAboTest.TestTechId = Environment.UserName;
			bloodUnitAboTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitAboTest);

			BloodUnitTest bloodUnitRhTest = new BloodUnitTest(bloodUnitGuid, 106);
			bloodUnitRhTest.TestDate = System.DateTime.Now;
			bloodUnitRhTest.TestResultId = "P";
			bloodUnitRhTest.EntryMethodCode = "M";
			bloodUnitRhTest.TestingMethod = testingMethod;
			bloodUnitRhTest.OrderableTestId = 10;
			bloodUnitRhTest.TestTechId = Environment.UserName;
			bloodUnitRhTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitRhTest);

			BloodUnitTest bloodUnitPreXmatchTest = new BloodUnitTest(bloodUnitGuid, 109);
			bloodUnitPreXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPreXmatchTest.TestResultId = "C";
			bloodUnitPreXmatchTest.EntryMethodCode = "M";
			bloodUnitPreXmatchTest.TestingMethod = testingMethod;
			bloodUnitPreXmatchTest.OrderableTestId = 10;
			bloodUnitPreXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPreXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPreXmatchTest);

			BloodUnitTest bloodUnitPostXmatchTest = new BloodUnitTest(bloodUnitGuid, 110);
			bloodUnitPostXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPostXmatchTest.TestResultId = "C";
			bloodUnitPostXmatchTest.EntryMethodCode = "M";
			bloodUnitPostXmatchTest.TestingMethod = testingMethod;
			bloodUnitPostXmatchTest.OrderableTestId = 10;
			bloodUnitPostXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPostXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPostXmatchTest);
			//
			// pre-transfusion ABO + Rh Interp
			SpecimenTest preSpecimenAboTest = new SpecimenTest();
			preSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenAboTest.OrderedTest = orderedTest;
			preSpecimenAboTest.TestTechId = Environment.UserName;
			preSpecimenAboTest.TestingMethod = testingMethod;
			preSpecimenAboTest.BloodTestType = new BloodTestType(105);
			preSpecimenAboTest.TestResult = new BOL.TestResult("A");
			preSpecimenAboTest.TestDate = System.DateTime.Now;
			preSpecimenAboTest.Rack = rack;
			preSpecimenAboTest.AutoInstrumentName = "A";
			preSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenAboTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenAboTest);

			SpecimenTest preSpecimenRhTest = new SpecimenTest();
			preSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenRhTest.OrderedTest = orderedTest;
			preSpecimenRhTest.TestTechId = Environment.UserName;
			preSpecimenRhTest.TestingMethod = testingMethod;
			preSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			preSpecimenRhTest.TestResult = new BOL.TestResult("P");
			preSpecimenRhTest.TestDate = System.DateTime.Now;
			preSpecimenRhTest.Rack = rack;
			preSpecimenRhTest.AutoInstrumentName = "A";
			preSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenRhTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenRhTest);
			
			// post-transfusion ABO + Rh Interp
			SpecimenTest postSpecimenAboTest = new SpecimenTest();
			postSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenAboTest.OrderedTest = orderedTest;
			postSpecimenAboTest.TestTechId = Environment.UserName;
			postSpecimenAboTest.TestingMethod = testingMethod;
			postSpecimenAboTest.BloodTestType = new BloodTestType(105);
			postSpecimenAboTest.TestResult = new BOL.TestResult("A");
			postSpecimenAboTest.TestDate = System.DateTime.Now;
			postSpecimenAboTest.Rack = rack;
			postSpecimenAboTest.AutoInstrumentName = "A";
			postSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenAboTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenAboTest);

			SpecimenTest postSpecimenRhTest = new SpecimenTest();
			postSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenRhTest.OrderedTest = orderedTest;
			postSpecimenRhTest.TestTechId = Environment.UserName;
			postSpecimenRhTest.TestingMethod = testingMethod;
			postSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			postSpecimenRhTest.TestResult = new BOL.TestResult("P");
			postSpecimenRhTest.TestDate = System.DateTime.Now;
			postSpecimenRhTest.Rack = rack;
			postSpecimenRhTest.AutoInstrumentName = "A";
			postSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenRhTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenRhTest);
			//
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			Assert.IsTrue(ptr.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests, orderedTest, null, workloads));
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void SaveSerologicTests_Fail()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];
			Rack rack = new BOL.Rack(rackGuid);
			//
			TestingMethod testingMethod = new TestingMethod("T");
			//
			// Blood Unit ABO + Rh Interp
			BloodUnitTest bloodUnitAboTest = new BloodUnitTest(bloodUnitGuid, 105);
			bloodUnitAboTest.TestDate = System.DateTime.Now;
			bloodUnitAboTest.TestResultId = "A";
			bloodUnitAboTest.EntryMethodCode = "M";
			bloodUnitAboTest.TestingMethod = testingMethod;
			bloodUnitAboTest.OrderableTestId = 10;
			bloodUnitAboTest.TestTechId = Environment.UserName;
			bloodUnitAboTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitAboTest);

			BloodUnitTest bloodUnitRhTest = new BloodUnitTest(bloodUnitGuid, 106);
			bloodUnitRhTest.TestDate = System.DateTime.Now;
			bloodUnitRhTest.TestResultId = "P";
			bloodUnitRhTest.EntryMethodCode = "M";
			bloodUnitRhTest.TestingMethod = testingMethod;
			bloodUnitRhTest.OrderableTestId = 10;
			bloodUnitRhTest.TestTechId = Environment.UserName;
			bloodUnitRhTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitRhTest);

			BloodUnitTest bloodUnitPreXmatchTest = new BloodUnitTest(bloodUnitGuid, 109);
			bloodUnitPreXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPreXmatchTest.TestResultId = "C";
			bloodUnitPreXmatchTest.EntryMethodCode = "M";
			bloodUnitPreXmatchTest.TestingMethod = testingMethod;
			bloodUnitPreXmatchTest.OrderableTestId = 10;
			bloodUnitPreXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPreXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPreXmatchTest);

			BloodUnitTest bloodUnitPostXmatchTest = new BloodUnitTest(bloodUnitGuid, 110);
			bloodUnitPostXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPostXmatchTest.TestResultId = "C";
			bloodUnitPostXmatchTest.EntryMethodCode = "M";
			bloodUnitPostXmatchTest.TestingMethod = testingMethod;
			bloodUnitPostXmatchTest.OrderableTestId = 10;
			bloodUnitPostXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPostXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPostXmatchTest);
			//
			// pre-transfusion ABO + Rh Interp
			SpecimenTest preSpecimenAboTest = new SpecimenTest();
			preSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenAboTest.OrderedTest = orderedTest;
			preSpecimenAboTest.TestTechId = Environment.UserName;
			preSpecimenAboTest.TestingMethod = testingMethod;
			preSpecimenAboTest.BloodTestType = new BloodTestType(105);
			preSpecimenAboTest.TestResult = new BOL.TestResult("A");
			preSpecimenAboTest.TestDate = System.DateTime.Now;
			preSpecimenAboTest.Rack = rack;
			preSpecimenAboTest.AutoInstrumentName = "A";
			preSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenAboTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenAboTest);

			SpecimenTest preSpecimenRhTest = new SpecimenTest();
			preSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenRhTest.OrderedTest = orderedTest;
			preSpecimenRhTest.TestTechId = Environment.UserName;
			preSpecimenRhTest.TestingMethod = testingMethod;
			preSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			preSpecimenRhTest.TestResult = new BOL.TestResult("P");
			preSpecimenRhTest.TestDate = System.DateTime.Now;
			preSpecimenRhTest.Rack = rack;
			preSpecimenRhTest.AutoInstrumentName = "A";
			preSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenRhTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenRhTest);
			
			// post-transfusion ABO + Rh Interp
			SpecimenTest postSpecimenAboTest = new SpecimenTest();
			postSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenAboTest.OrderedTest = orderedTest;
			postSpecimenAboTest.TestTechId = Environment.UserName;
			postSpecimenAboTest.TestingMethod = testingMethod;
			postSpecimenAboTest.BloodTestType = new BloodTestType(105);
			postSpecimenAboTest.TestResult = new BOL.TestResult("A");
			postSpecimenAboTest.TestDate = System.DateTime.Now;
			postSpecimenAboTest.Rack = rack;
			postSpecimenAboTest.AutoInstrumentName = "A";
			postSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenAboTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenAboTest);

			SpecimenTest postSpecimenRhTest = new SpecimenTest();
			postSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenRhTest.OrderedTest = orderedTest;
			postSpecimenRhTest.TestTechId = Environment.UserName;
			postSpecimenRhTest.TestingMethod = testingMethod;
			postSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			postSpecimenRhTest.TestResult = new BOL.TestResult("P");
			postSpecimenRhTest.TestDate = System.DateTime.Now;
			postSpecimenRhTest.Rack = rack;
			postSpecimenRhTest.AutoInstrumentName = "A";
			postSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenRhTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenRhTest);
			//
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			Assert.IsTrue(!ptr.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests, orderedTest, null, workloads));
		}

		[Test]
		public void GetSerologicBloodUnitTests_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];
			Rack rack = new BOL.Rack(rackGuid);
			//
			TestingMethod testingMethod = new TestingMethod("T");
			//
			// Blood Unit ABO + Rh Interp
			BloodUnitTest bloodUnitAboTest = new BloodUnitTest(bloodUnitGuid, 105);
			bloodUnitAboTest.TestDate = System.DateTime.Now;
			bloodUnitAboTest.TestResultId = "A";
			bloodUnitAboTest.EntryMethodCode = "M";
			bloodUnitAboTest.TestingMethod = testingMethod;
			bloodUnitAboTest.OrderableTestId = 10;
			bloodUnitAboTest.TestTechId = Environment.UserName;
			bloodUnitAboTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitAboTest);

			BloodUnitTest bloodUnitRhTest = new BloodUnitTest(bloodUnitGuid, 106);
			bloodUnitRhTest.TestDate = System.DateTime.Now;
			bloodUnitRhTest.TestResultId = "P";
			bloodUnitRhTest.EntryMethodCode = "M";
			bloodUnitRhTest.TestingMethod = testingMethod;
			bloodUnitRhTest.OrderableTestId = 10;
			bloodUnitRhTest.TestTechId = Environment.UserName;
			bloodUnitRhTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitRhTest);

			BloodUnitTest bloodUnitPreXmatchTest = new BloodUnitTest(bloodUnitGuid, 109);
			bloodUnitPreXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPreXmatchTest.TestResultId = "C";
			bloodUnitPreXmatchTest.EntryMethodCode = "M";
			bloodUnitPreXmatchTest.TestingMethod = testingMethod;
			bloodUnitPreXmatchTest.OrderableTestId = 10;
			bloodUnitPreXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPreXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPreXmatchTest);

			BloodUnitTest bloodUnitPostXmatchTest = new BloodUnitTest(bloodUnitGuid, 110);
			bloodUnitPostXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPostXmatchTest.TestResultId = "C";
			bloodUnitPostXmatchTest.EntryMethodCode = "M";
			bloodUnitPostXmatchTest.TestingMethod = testingMethod;
			bloodUnitPostXmatchTest.OrderableTestId = 10;
			bloodUnitPostXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPostXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPostXmatchTest);
			//
			// pre-transfusion ABO + Rh Interp
			SpecimenTest preSpecimenAboTest = new SpecimenTest();
			preSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenAboTest.OrderedTest = orderedTest;
			preSpecimenAboTest.TestTechId = Environment.UserName;
			preSpecimenAboTest.TestingMethod = testingMethod;
			preSpecimenAboTest.BloodTestType = new BloodTestType(105);
			preSpecimenAboTest.TestResult = new BOL.TestResult("A");
			preSpecimenAboTest.TestDate = System.DateTime.Now;
			preSpecimenAboTest.Rack = rack;
			preSpecimenAboTest.AutoInstrumentName = "A";
			preSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenAboTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenAboTest);

			SpecimenTest preSpecimenRhTest = new SpecimenTest();
			preSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenRhTest.OrderedTest = orderedTest;
			preSpecimenRhTest.TestTechId = Environment.UserName;
			preSpecimenRhTest.TestingMethod = testingMethod;
			preSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			preSpecimenRhTest.TestResult = new BOL.TestResult("P");
			preSpecimenRhTest.TestDate = System.DateTime.Now;
			preSpecimenRhTest.Rack = rack;
			preSpecimenRhTest.AutoInstrumentName = "A";
			preSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenRhTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenRhTest);
			
			// post-transfusion ABO + Rh Interp
			SpecimenTest postSpecimenAboTest = new SpecimenTest();
			postSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenAboTest.OrderedTest = orderedTest;
			postSpecimenAboTest.TestTechId = Environment.UserName;
			postSpecimenAboTest.TestingMethod = testingMethod;
			postSpecimenAboTest.BloodTestType = new BloodTestType(105);
			postSpecimenAboTest.TestResult = new BOL.TestResult("A");
			postSpecimenAboTest.TestDate = System.DateTime.Now;
			postSpecimenAboTest.Rack = rack;
			postSpecimenAboTest.AutoInstrumentName = "A";
			postSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenAboTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenAboTest);

			SpecimenTest postSpecimenRhTest = new SpecimenTest();
			postSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenRhTest.OrderedTest = orderedTest;
			postSpecimenRhTest.TestTechId = Environment.UserName;
			postSpecimenRhTest.TestingMethod = testingMethod;
			postSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			postSpecimenRhTest.TestResult = new BOL.TestResult("P");
			postSpecimenRhTest.TestDate = System.DateTime.Now;
			postSpecimenRhTest.Rack = rack;
			postSpecimenRhTest.AutoInstrumentName = "A";
			postSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenRhTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenRhTest);
			//
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			ptr.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests, orderedTest, null, workloads);
			ArrayList tests = ptr.GetSerologicBloodUnitTests();
			Assert.IsTrue(tests.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSerologicBloodUnitTests_Fail()
		{
			
		}

		[Test]
		public void GetSerologicSpecimenTests_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];
			Rack rack = new BOL.Rack(rackGuid);
			//
			TestingMethod testingMethod = new TestingMethod("T");
			//
			// Blood Unit ABO + Rh Interp
			BloodUnitTest bloodUnitAboTest = new BloodUnitTest(bloodUnitGuid, 105);
			bloodUnitAboTest.TestDate = System.DateTime.Now;
			bloodUnitAboTest.TestResultId = "A";
			bloodUnitAboTest.EntryMethodCode = "M";
			bloodUnitAboTest.TestingMethod = testingMethod;
			bloodUnitAboTest.OrderableTestId = 10;
			bloodUnitAboTest.TestTechId = Environment.UserName;
			bloodUnitAboTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitAboTest);

			BloodUnitTest bloodUnitRhTest = new BloodUnitTest(bloodUnitGuid, 106);
			bloodUnitRhTest.TestDate = System.DateTime.Now;
			bloodUnitRhTest.TestResultId = "P";
			bloodUnitRhTest.EntryMethodCode = "M";
			bloodUnitRhTest.TestingMethod = testingMethod;
			bloodUnitRhTest.OrderableTestId = 10;
			bloodUnitRhTest.TestTechId = Environment.UserName;
			bloodUnitRhTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitRhTest);

			BloodUnitTest bloodUnitPreXmatchTest = new BloodUnitTest(bloodUnitGuid, 109);
			bloodUnitPreXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPreXmatchTest.TestResultId = "C";
			bloodUnitPreXmatchTest.EntryMethodCode = "M";
			bloodUnitPreXmatchTest.TestingMethod = testingMethod;
			bloodUnitPreXmatchTest.OrderableTestId = 10;
			bloodUnitPreXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPreXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPreXmatchTest);

			BloodUnitTest bloodUnitPostXmatchTest = new BloodUnitTest(bloodUnitGuid, 110);
			bloodUnitPostXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPostXmatchTest.TestResultId = "C";
			bloodUnitPostXmatchTest.EntryMethodCode = "M";
			bloodUnitPostXmatchTest.TestingMethod = testingMethod;
			bloodUnitPostXmatchTest.OrderableTestId = 10;
			bloodUnitPostXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPostXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPostXmatchTest);
			//
			// pre-transfusion ABO + Rh Interp
			SpecimenTest preSpecimenAboTest = new SpecimenTest();
			preSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenAboTest.OrderedTest = orderedTest;
			preSpecimenAboTest.TestTechId = Environment.UserName;
			preSpecimenAboTest.TestingMethod = testingMethod;
			preSpecimenAboTest.BloodTestType = new BloodTestType(105);
			preSpecimenAboTest.TestResult = new BOL.TestResult("A");
			preSpecimenAboTest.TestDate = System.DateTime.Now;
			preSpecimenAboTest.Rack = rack;
			preSpecimenAboTest.AutoInstrumentName = "A";
			preSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenAboTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenAboTest);

			SpecimenTest preSpecimenRhTest = new SpecimenTest();
			preSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenRhTest.OrderedTest = orderedTest;
			preSpecimenRhTest.TestTechId = Environment.UserName;
			preSpecimenRhTest.TestingMethod = testingMethod;
			preSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			preSpecimenRhTest.TestResult = new BOL.TestResult("P");
			preSpecimenRhTest.TestDate = System.DateTime.Now;
			preSpecimenRhTest.Rack = rack;
			preSpecimenRhTest.AutoInstrumentName = "A";
			preSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenRhTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenRhTest);
			
			// post-transfusion ABO + Rh Interp
			SpecimenTest postSpecimenAboTest = new SpecimenTest();
			postSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenAboTest.OrderedTest = orderedTest;
			postSpecimenAboTest.TestTechId = Environment.UserName;
			postSpecimenAboTest.TestingMethod = testingMethod;
			postSpecimenAboTest.BloodTestType = new BloodTestType(105);
			postSpecimenAboTest.TestResult = new BOL.TestResult("A");
			postSpecimenAboTest.TestDate = System.DateTime.Now;
			postSpecimenAboTest.Rack = rack;
			postSpecimenAboTest.AutoInstrumentName = "A";
			postSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenAboTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenAboTest);

			SpecimenTest postSpecimenRhTest = new SpecimenTest();
			postSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenRhTest.OrderedTest = orderedTest;
			postSpecimenRhTest.TestTechId = Environment.UserName;
			postSpecimenRhTest.TestingMethod = testingMethod;
			postSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			postSpecimenRhTest.TestResult = new BOL.TestResult("P");
			postSpecimenRhTest.TestDate = System.DateTime.Now;
			postSpecimenRhTest.Rack = rack;
			postSpecimenRhTest.AutoInstrumentName = "A";
			postSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenRhTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenRhTest);
			//
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			ptr.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests, orderedTest, null, workloads);
			ArrayList tests = ptr.GetSerologicSpecimenTests();
			Assert.IsTrue(tests.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSerologicSpecimenTests_Fail()
		{
		}

		[Test]
		public void GetTransfusionReactionRecords_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			//
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ArrayList records = ptr.GetTransfusionReactionRecords();
			Assert.IsTrue(records.Count > 0, "Method failed:");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionReactionRecords_Fail()
		{
		}

		[Test]
		public void UpdateStatus_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ptr.RecordStatusCode = Common.RecordStatusCode.Inactive;
			bool success = ptr.UpdateStatus();
			Assert.IsTrue(success);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UpdateStatus_Fail()
		{
		}


		[Test]
		public void Invalidate_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			bool success = ptr.Invalidate(orderedTest);
			Assert.IsTrue(success);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Invalidate_Fail()
		{
		}

		[Test]
		public void GetHemolysisInspectionList_Pass()
		{
			ArrayList list = PatientTransfusionReaction.GetHemolysisInspectionList();
			Assert.IsTrue(list.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetHemolysisInspectionList_Fail()
		{

		}

		[Test]
		public void GetPatientSymptomList_Pass()
		{
			ArrayList list = PatientTransfusionReaction.GetPatientSymptomList();
			Assert.IsTrue(list.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientSymptomList_Fail()
		{
		}

		[Test]
		public void PartialSaveId_Pass()
		{
			this._tstPTR.PartialSaveId = Common.PatientTransfusionPartialSaveId.SerologicTestsComplete;
			Assert.AreEqual(this._tstPTR.PartialSaveId, Common.PatientTransfusionPartialSaveId.SerologicTestsComplete);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PartialSaveId_Fail()
		{
		}

		[Test]
		public void PostSpecimenClericalChecksOKIndicator_Pass()
		{
			this._tstPTR.PostSpecimenClericalChecksOKIndicator = true;
			Assert.AreEqual(this._tstPTR.PostSpecimenClericalChecksOKIndicator, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PostSpecimenClericalChecksOKIndicator_Fail()
		{
		}

		[Test]
		public void PreSpecimenClericalChecksOKIndicator_Pass()
		{
			this._tstPTR.PreSpecimenClericalChecksOKIndicator = true;
			Assert.AreEqual(this._tstPTR.PreSpecimenClericalChecksOKIndicator, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PreSpecimenClericalChecksOKIndicator_Fail()
		{
		}

		[Test]
		public void GetImplicatedTransfusionRecords_Empty_Pass()
		{
			ArrayList list=this._tstPTR.GetImplicatedTransfusionRecords();
			Assert.IsTrue(list.Count>=0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetImplicatedTransfusionRecords_Empty_Fail()
		{
		}

		[Test]
		public void Invalidate_IncludingTests_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			ArrayList transfusionReactions = new ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			ArrayList symptoms = new ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];
			Rack rack = new BOL.Rack(rackGuid);
			//
			TestingMethod testingMethod = new TestingMethod("T");
			//
			// Blood Unit ABO + Rh Interp
			BloodUnitTest bloodUnitAboTest = new BloodUnitTest(bloodUnitGuid, 105);
			bloodUnitAboTest.TestDate = System.DateTime.Now;
			bloodUnitAboTest.TestResultId = "A";
			bloodUnitAboTest.EntryMethodCode = "M";
			bloodUnitAboTest.TestingMethod = testingMethod;
			bloodUnitAboTest.OrderableTestId = 10;
			bloodUnitAboTest.TestTechId = Environment.UserName;
			bloodUnitAboTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitAboTest);

			BloodUnitTest bloodUnitRhTest = new BloodUnitTest(bloodUnitGuid, 106);
			bloodUnitRhTest.TestDate = System.DateTime.Now;
			bloodUnitRhTest.TestResultId = "P";
			bloodUnitRhTest.EntryMethodCode = "M";
			bloodUnitRhTest.TestingMethod = testingMethod;
			bloodUnitRhTest.OrderableTestId = 10;
			bloodUnitRhTest.TestTechId = Environment.UserName;
			bloodUnitRhTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitRhTest);

			BloodUnitTest bloodUnitPreXmatchTest = new BloodUnitTest(bloodUnitGuid, 109);
			bloodUnitPreXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPreXmatchTest.TestResultId = "C";
			bloodUnitPreXmatchTest.EntryMethodCode = "M";
			bloodUnitPreXmatchTest.TestingMethod = testingMethod;
			bloodUnitPreXmatchTest.OrderableTestId = 10;
			bloodUnitPreXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPreXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPreXmatchTest);

			BloodUnitTest bloodUnitPostXmatchTest = new BloodUnitTest(bloodUnitGuid, 110);
			bloodUnitPostXmatchTest.TestDate = System.DateTime.Now;
			bloodUnitPostXmatchTest.TestResultId = "C";
			bloodUnitPostXmatchTest.EntryMethodCode = "M";
			bloodUnitPostXmatchTest.TestingMethod = testingMethod;
			bloodUnitPostXmatchTest.OrderableTestId = 10;
			bloodUnitPostXmatchTest.TestTechId = Environment.UserName;
			bloodUnitPostXmatchTest.Rack = rack;
			bloodUnitTests.Add(bloodUnitPostXmatchTest);
			//
			// pre-transfusion ABO + Rh Interp
			SpecimenTest preSpecimenAboTest = new SpecimenTest();
			preSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenAboTest.OrderedTest = orderedTest;
			preSpecimenAboTest.TestTechId = Environment.UserName;
			preSpecimenAboTest.TestingMethod = testingMethod;
			preSpecimenAboTest.BloodTestType = new BloodTestType(105);
			preSpecimenAboTest.TestResult = new BOL.TestResult("A");
			preSpecimenAboTest.TestDate = System.DateTime.Now;
			preSpecimenAboTest.Rack = rack;
			preSpecimenAboTest.AutoInstrumentName = "A";
			preSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenAboTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenAboTest);

			SpecimenTest preSpecimenRhTest = new SpecimenTest();
			preSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			preSpecimenRhTest.OrderedTest = orderedTest;
			preSpecimenRhTest.TestTechId = Environment.UserName;
			preSpecimenRhTest.TestingMethod = testingMethod;
			preSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			preSpecimenRhTest.TestResult = new BOL.TestResult("P");
			preSpecimenRhTest.TestDate = System.DateTime.Now;
			preSpecimenRhTest.Rack = rack;
			preSpecimenRhTest.AutoInstrumentName = "A";
			preSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			preSpecimenRhTest.LastUpdateUser = Environment.UserName;
			preSpecimenTests.Add(preSpecimenRhTest);
			
			// post-transfusion ABO + Rh Interp
			SpecimenTest postSpecimenAboTest = new SpecimenTest();
			postSpecimenAboTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenAboTest.OrderedTest = orderedTest;
			postSpecimenAboTest.TestTechId = Environment.UserName;
			postSpecimenAboTest.TestingMethod = testingMethod;
			postSpecimenAboTest.BloodTestType = new BloodTestType(105);
			postSpecimenAboTest.TestResult = new BOL.TestResult("A");
			postSpecimenAboTest.TestDate = System.DateTime.Now;
			postSpecimenAboTest.Rack = rack;
			postSpecimenAboTest.AutoInstrumentName = "A";
			postSpecimenAboTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenAboTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenAboTest);

			SpecimenTest postSpecimenRhTest = new SpecimenTest();
			postSpecimenRhTest.SpecimenTestGuid = Guid.NewGuid();
			postSpecimenRhTest.OrderedTest = orderedTest;
			postSpecimenRhTest.TestTechId = Environment.UserName;
			postSpecimenRhTest.TestingMethod = testingMethod;
			postSpecimenRhTest.BloodTestType  = new BloodTestType(106);
			postSpecimenRhTest.TestResult = new BOL.TestResult("P");
			postSpecimenRhTest.TestDate = System.DateTime.Now;
			postSpecimenRhTest.Rack = rack;
			postSpecimenRhTest.AutoInstrumentName = "A";
			postSpecimenRhTest.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			postSpecimenRhTest.LastUpdateUser = Environment.UserName;
			postSpecimenTests.Add(postSpecimenRhTest);
			//
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			ptr.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests, orderedTest, null, workloads);
			//
			//Now that the TRW is complete, we can invalidate it!
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			Assert.IsTrue(ptr.Invalidate(orderedTest, ptr.GetSerologicBloodUnitTests(), ptr.GetSerologicSpecimenTests(), "UNIT TEST 6516", true, Common.UpdateFunction.UC094FrmInvalidatePatientTestResults, Guid.NewGuid(),  workloads));
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Invalidate_IncludingTests_Fail()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			BOL.PatientTransfusionReaction ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			ptr.PartialSaveId = Common.PatientTransfusionPartialSaveId.ReportFinalized;
			Assert.IsTrue(!ptr.Invalidate(new BOL.OrderedTest(orderedTestGuid, patientOrderGuid), new ArrayList(), new ArrayList(), "UNIT TEST 6517", false, Common.UpdateFunction.UC094FrmInvalidatePatientTestResults, Guid.NewGuid(),  new ArrayList()));
		}

		[Test]
		public void FinalizeReport_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			//
			//Now we can enter all phases of a TRW...
			ArrayList bloodUnitTests = new ArrayList();
			ArrayList postSpecimenTests = new ArrayList();
			ArrayList preSpecimenTests = new ArrayList();

			PatientTransfusionReaction ptr = new PatientTransfusionReaction(orderedTestGuid);
			OrderedTest orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			ArrayList specimens = new ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			ptr.SaveSpecimenCheckData(orderedTest, new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ptr.SaveImplicatedBloodUnits(new ArrayList(), new ArrayList(), null);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			PatientTransfusionComment ptc=new PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode.SymptomDetails);
			ptc.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			ptc.Comments="UNIT TEST 6697";
			ptc.DivisionCode=UnitTestConfig.TestDivisionCode; 
			ptc.RecordStatusCode = "A";
			ptr.SaveSymptoms(new ArrayList(), ptc);
			//
			ptr = new PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new OrderedTest(orderedTestGuid, patientOrderGuid);
			ArrayList workloads = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			workloads.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			ptr.SaveSerologicTests(new ArrayList(), new ArrayList(), new ArrayList(), orderedTest, null, workloads);
			//
			DataRow drTrwComment = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 CannedCommentGuid FROM CannedComment WHERE CannedCommentCategoryCode = 'TW'");
			PatientTransfusionComment ptcF =new PatientTransfusionComment();
			ptcF.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			ptcF.CommentCategoryCode = "TW";
			ptcF.CannedCommentGuid = (Guid)drTrwComment[TABLES.CannedComment.CannedCommentGuid];
			ptcF.PatientTransfusionCommentText="UNIT TEST 6697";
			ptcF.DivisionCode=UnitTestConfig.TestDivisionCode; 
			ptcF.RecordStatusCode = "A";

			ptr = new PatientTransfusionReaction(orderedTestGuid);
			ptr.MedicalDirectorName = "UNIT TEST DIRECTOR";
			ptr.TransfusionReactionTypeCode = Common.TransfusionReactionType.GraftVsHostDisease;
			Assert.IsTrue(ptr.FinalizeReport(ptcF, Common.UpdateFunction.UnitTests));
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void FinalizeReport_Fail()
		{
			BOL.PatientTransfusionReaction ptr = new PatientTransfusionReaction(System.Guid.NewGuid());
			bool retValue = ptr.FinalizeReport(new PatientTransfusionComment(), Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "ReturnValue");		
		}

		[Test]
		public void GetCompletedPatientTrnsfusionReactions_Pass()
		{
			DataTable dtReacts=BOL.PatientTransfusionReaction.GetCompletedPatientTransfusionReactions();
			
			Assert.IsNotNull(dtReacts);
			Assert.IsTrue(dtReacts.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCompletedPatientTrnsfusionReactions_Fail()
		{
		}

		[Test]
		public void PreSpecimenHemolysisInspectionCode_Pass()
		{
			string code = "T";
			//
			this._tstPTR.PreSpecimenHemolysisInspectionCode = code;
			//
			Assert.IsTrue( this._tstPTR.PreSpecimenHemolysisInspectionCode.Equals( code ) );
		}

		[Test]
		public void PreSpecimenHemolysisInspectionCode_Fail()
		{
			this._tstPTR.SetInitialBrokenRules("FrmTransfusionReactionWorkup","TrwHemolysis");
			this._tstPTR.PreSpecimenNotAvailableIndicator = false;
			this._tstPTR.PreSpecimenHemolysisInspectionCode = "1";
			int initialCount = this._tstPTR.BrokenRulesCount;
			//
			this._tstPTR.PreSpecimenHemolysisInspectionCode = null;
			//
			Assert.IsTrue( this._tstPTR.BrokenRulesCount > initialCount );
		}

		[Test]
		public void PostSpecimenHemolysisInspectionCode_Pass()
		{
			string code = "T";
			//
			this._tstPTR.PostSpecimenHemolysisInspectionCode = code;
			//
			Assert.IsTrue( this._tstPTR.PostSpecimenHemolysisInspectionCode.Equals( code ) );
		}

		[Test]
		public void PostSpecimenHemolysisInspectionCode_Fail()
		{
			this._tstPTR.SetInitialBrokenRules("FrmTransfusionReactionWorkup","TrwHemolysis");
			this._tstPTR.PostSpecimenNotAvailableIndicator = false;
			this._tstPTR.PostSpecimenHemolysisInspectionCode = "1";
			int initialCount = this._tstPTR.BrokenRulesCount;
			//
			this._tstPTR.PostSpecimenHemolysisInspectionCode = null;
			//
			Assert.IsTrue( this._tstPTR.BrokenRulesCount > initialCount );
		}

		#region Helper Methods



		private DataRow GetDataForPersistingNewPtr()
		{
			// Load the guids we'll need for a majority of the tests here
			StringBuilder query = new StringBuilder("SELECT TOP 1 Patient.PatientGuid, ");
			query.Append("PatientTransfusion.PatientTransfusionGuid, PatientTransfusion.BloodUnitGuid, ");
			query.Append("PatientTreatment.PatientTreatmentGuid, PatientOrder.PatientOrderGuid,  ");
			query.Append("OrderedTest.OrderedTestGuid, OrderedTest.RowVersion AS OrderedTestRowVersion, ");
			query.Append("PSPRE.PatientSpecimenGuid AS PreSpecimenGuid, PSPRE.Specimenuid AS PreSpecimenuid, ");
			query.Append("PSPRE.RowVersion AS PreSpecimenRowVersion, ");
			query.Append("PSPOST.PatientSpecimenGuid AS PostSpecimenGuid, PSPOST.Specimenuid AS PostSpecimenuid, ");
			query.Append("PSPOST.RowVersion AS PostSpecimenRowVersion ");
			query.Append(" FROM Patient ");
			query.Append("JOIN PatientTransfusion ON Patient.PatientGuid = PatientTransfusion.PatientGuid ");
			query.Append("JOIN PatientTreatment ON Patient.PatientGuid = PatientTreatment.PatientGuid ");
			query.Append("JOIN PatientOrder ON PatientTreatment.PatientTreatmentGUID = PatientOrder.PatientTreatmentGuid ");
			query.Append("JOIN OrderedTest ON PatientOrder.PatientOrderGuid = OrderedTest.PatientOrderGuid ");
			query.Append("JOIN PatientTransfusionReaction PTR ON OrderedTest.OrderedTestGuid = PTR.OrderedTestGuid ");
			query.Append("LEFT OUTER JOIN PatientSpecimen AS PSPOST ON PTR.PostSpecimenGuid = PSPOST.PatientSpecimenGuid ");
			query.Append("LEFT OUTER JOIN PatientSpecimen AS PSPRE ON PTR.PreSpecimenGuid = PSPRE.PatientSpecimenGuid ");
			query.Append("WHERE PatientOrder.DivisionCode = '").Append(UnitTestConfig.TestDivisionCode).Append("' ");
			query.Append("AND OrderedTest.DivisionCode = '").Append(UnitTestConfig.TestDivisionCode).Append("' ");
			query.Append("AND PSPOST.PatientSpecimenGuid IS NOT NULL");

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), false);

			if (dtTemp.Rows.Count == 0)
			{
				Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");
				Guid ps1Guid = Guid.NewGuid();
				Guid ps2Guid = Guid.NewGuid();
				Guid otGuid = Guid.NewGuid();
				Guid ptrGuid = Guid.NewGuid();
				Guid poGuid = Guid.NewGuid();
				Guid ptGuid = Guid.NewGuid();
				Guid bpGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.RBC).BloodProductGuid;
				int uid = System.Convert.ToInt32(DataCreator.GetNewSpecimenUid());

				Guid bu1Guid = Guid.NewGuid();
				DataCreator.CreateBloodUnit(bu1Guid, Guid.NewGuid(), patientGuid, bpGuid, true);
				
				System.Collections.ArrayList dtArray = new System.Collections.ArrayList();
				System.Collections.ArrayList sprocArray = new System.Collections.ArrayList();
				dtArray.Add(SprocHelper.GetInsertPatientTreatmentSprocTable(ptGuid, patientGuid));
				sprocArray.Add(SPROCS.InsertPatientTreatment.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid, false));
				sprocArray.Add(SPROCS.InsertPatientOrder.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertPatientSpecimenSprocTable(ps1Guid, patientGuid, uid.ToString()));
				sprocArray.Add(SPROCS.InsertPatientSpecimen.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertPatientSpecimenSprocTable(ps2Guid, patientGuid, (uid+1).ToString()));
				sprocArray.Add(SPROCS.InsertPatientSpecimen.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertOrderedTestSprocTable(otGuid, poGuid, ps1Guid));
				sprocArray.Add(SPROCS.InsertOrderedTest.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertPatientTransfusionSprocTable(ptGuid, patientGuid, bu1Guid));
				sprocArray.Add(SPROCS.InsertPatientTransfusion.StoredProcName);
				dtArray.Add(SprocHelper.GetInsertPatientTransfusionReactionSprocTable(ptrGuid, patientGuid, otGuid, ps1Guid, ps2Guid));
				sprocArray.Add(SPROCS.InsertPatientTransfusionReaction.StoredProcName);

				new Common.StoredProcedure().TransactionalGetValue(sprocArray, dtArray);

			}

			dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), true);
			return dtTemp.Rows[0];
		}

		//Creates test data, because this crap fades fast for some reason
		private void CreateTestData()
		{
			System.Guid patientTransfusionGuid = System.Guid.NewGuid();
			System.Guid patientTransfusionReactionGuid = System.Guid.NewGuid();
			System.Guid transfusionReactionGuid = System.Guid.NewGuid();

			string sql = string.Empty;

			//Create the PatientTransfusion Data
			sql = " INSERT INTO PatientTransfusion (PatientTransfusionGuid, PatientGuid,  " + 
				" LastUpdateUser, LastUpdateDate, LastUpdateFunctionId, RecordStatusCode, DivisionCode)" +
				" VALUES ('" + patientTransfusionGuid.ToString() + "','" + this._dtPatient.Rows[0][TABLES.Patient.PatientGuid].ToString() + "','" +
				Common.LogonUser.LogonUserName + "','" + System.DateTime.Now.ToString() + "',999,'A','" + UnitTestConfig.TestDivisionCode + "')";
			UnitTestUtil.RunSQLGetDataTable(sql);


			//Create the PatientTransfusionReaction Data
			sql = " INSERT INTO PatientTransfusionReaction (PatientTransfusionReactionGuid, PatientGuid,  " + 
				" LastUpdateUser, LastUpdateDate, LastUpdateFunctionId, RecordStatusCode, TransfusionReactionTypeCode, DivisionCode)" +
				" VALUES ('" + patientTransfusionReactionGuid.ToString() + "','" + this._dtPatient.Rows[0][TABLES.Patient.PatientGuid].ToString() + "','" +
				Common.LogonUser.LogonUserName + "','" + System.DateTime.Now.ToString() + "',999,'A','A','" + UnitTestConfig.TestDivisionCode + "')";
			UnitTestUtil.RunSQL(sql);

			//Create the TransfusionReaction Data
			sql = " INSERT INTO TransfusionReaction (TransfusionReactionGuid, PatientTransfusionGuid, PatientTransfusionReactionGuid, " + 
				" LastUpdateUser, LastUpdateDate, LastUpdateFunctionId)" +
				" VALUES ('" + transfusionReactionGuid.ToString() + "','" + patientTransfusionGuid.ToString() + "','" + patientTransfusionReactionGuid.ToString() + "','" + 
				Common.LogonUser.LogonUserName + "','" + System.DateTime.Now.ToString() + "',999)";
			UnitTestUtil.RunSQL(sql);

		}

		public static void InsertPatientTreatment(Guid patientTreatmentGuid, Guid patientGuid)
		{
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertPatientTreatment);
		}

		public static void InsertPatientOrder(Guid patientOrderGuid, Guid patientTreatmentGuid)
		{
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertPatientOrder);
		}

		public static void InsertPatientSpecimen(Guid patientSpecimenGuid, Guid patientGuid, bool isPreSpecimen)
		{
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenReceivedDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenExpirationDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			if (isPreSpecimen)
			{
				insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "P',";
			}
			else
			{
				insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			}
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(3)) + "',";
			insertPatientSpecimen += "'R',";
			insertPatientSpecimen += "0,";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'" + Environment.UserName + "',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertPatientSpecimen);
		}

		public static void InsertOrderedTest(Guid orderedTestGuid, Guid patientOrderGuid, Guid patientSpecimenGuid, Common.OrderableTest orderableTest)
		{
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'" + Convert.ToInt32(orderableTest).ToString() + "',";
            insertOrderedTest += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'I',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'" + Environment.UserName + "',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertOrderedTest);
		}

		public static void InsertOrderedComponent(Guid orderedComponentGuid, Guid patientOrderGuid, Common.ComponentClass componentClass, int quantity)
		{
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(componentClass).ToString() + "',";
            insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += quantity.ToString() + ",";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertOrderedComponent);
		}

		public static void InsertOrderedUnit(Guid orderedUnitGuid, Guid orderedComponentGuid, Guid bloodUnitGuid)
		{
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertOrderedUnit);
		}

		public static void InsertBloodUnitTest(Guid bloodUnitTestGuid, Guid bloodUnitGuid, Guid orderedComponentGuid, Guid orderedUnitGuid, int bloodTestTypeId, string testResultId)
		{
			string insertBloodUnitTest = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest += "VALUES (";
			insertBloodUnitTest += "'" + bloodUnitTestGuid.ToString() + "',";
			insertBloodUnitTest += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest += bloodTestTypeId.ToString() + ",";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'" + testResultId + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'M',";
			insertBloodUnitTest += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest += "'2',";
			insertBloodUnitTest += "'A',";
			insertBloodUnitTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertBloodUnitTest);
		}

		public static void InsertIssuedUnit(Guid issuedUnitGuid, Guid bloodUnitGuid)
		{
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertIssuedUnit);
		}

		public static void InsertPatientTransfusion(Guid patientTransfusionGuid, Guid patientGuid, Guid bloodUnitGuid)
		{
			string insertPatientTransfusion = "INSERT INTO PATIENTTRANSFUSION (";
			insertPatientTransfusion += TABLES.PatientTransfusion.PatientTransfusionGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.PatientGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.BloodUnitGuid + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.ReactionIndicator + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.OtherDifficultyIndicator + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.DivisionCode + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateDate + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateUser + ",";
			insertPatientTransfusion += TABLES.PatientTransfusion.LastUpdateFunctionId + ")";
			insertPatientTransfusion += "VALUES (";
			insertPatientTransfusion += "'" + patientTransfusionGuid.ToString() + "',";
			insertPatientTransfusion += "'" + patientGuid.ToString() + "',";
			insertPatientTransfusion += "'" + bloodUnitGuid.ToString() + "',";
			insertPatientTransfusion += "0,";
			insertPatientTransfusion += "0,";
			insertPatientTransfusion += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientTransfusion += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTransfusion += "'" + Environment.UserName + "',";
			insertPatientTransfusion += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertPatientTransfusion);
		}



		#endregion

	}
}
#endif

